//
//  OPRoom.h
//  The Obfuscated Path
//
//  Created by ss2cire on 12/6/08.
//  Copyright 2008 GryphonClaw Software. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "OPTypes.h"

@class OPPlayer, OPRoomLayer, OPTrigger, OPItem;
@class OPSprite;

@interface OPRoom : NSObject
{
	OPPoint				scroll;
	NSMutableArray		*roomLayers;
	NSMutableArray		*triggers;
	NSMutableArray		*items;
	NSArray				*enemyList;
	NSMutableArray		*enemies;
	OPPlayer			*player;
	BOOL				currentRoom;
}
- (id)initWithRoomData:(NSString *)mapName;
- (void)loadLayerData:(NSString *)inData;
- (void)loadEventData:(NSDictionary *)triggerData withName:(NSString *)triggerName;
- (void)loadEnemyList:(NSArray *)inData;

- (void)draw;
- (void)update;

- (void)scrollXBy:(int)value;
- (void)scrollYBy:(int)value;

- (void)resetScroll;
- (void)resetXScroll;
- (void)resetYScroll;

- (OPRoomLayer *)layer:(OPLayer)layer;
- (OPSprite *)tileOnObjectLayerAtX:(int)x andY:(int)y;

- (int)xOffset;
- (int)yOffset;

- (OPPlayer *)player;

- (void)drawPlayer;

- (void)setCurrent;
- (void)removeCurrent;
- (BOOL)isCurrent;
- (NSArray *)triggers;

- (void)addItem:(OPItem *)anItem;
- (NSMutableArray *)items;

- (void)spawnEnemies;
- (void)removeEnemies;
- (NSMutableArray *)enemies;


- (void)entered;
- (void)exited;
@end
